#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Decibel Conversion Calculator, dbconv.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $imp = $FORM{'imp'};

my $ans = $FORM{'ans'};
my $ans_val = $FORM{'ans_val'};

# Clean up user input data
#
$imp =~ tr/0-9.//csd;

if (!$imp) {
  $imp = 50; # 50 ohms
}

$ans =~ tr/0-9.-//csd;
$ans_val =~ tr/a-zA-Z //csd;

if (!$ans) {
  $ans = 20; $ans_val = "dBm to mW"; # 20 dBm
}

# Start calculations
#
if ($ans_val eq "dBm to mW") {
  $dbm = $ans;
  $mw = 10 ** ($dbm / 10);
  $v = sqrt (( 10 ** ($dbm / 10) / 1000) * $imp);
  $vr = 10 ** ($dbm / 20);
  $pr = 10 ** ($dbm / 10);
  $m = "m";
}
elsif ($ans_val eq "mW to dBm") {
  $mw = $ans;
  $dbm = 10 * (log10 $mw);
  $v = sqrt (( 10 ** ($dbm / 10) / 1000) * $imp);
  $vr = 10 ** ($dbm / 20);
  $pr = 10 ** ($dbm / 10);
  $m = "m";
}
elsif ($ans_val eq "dB to power ratio") {
  $dbm = $ans;
  $mw = 0;
  $v = 0;
  $vr = 10 ** ($dbm / 20);
  $pr = 10 ** ($dbm / 10);
  $m = " ";
}
elsif ($ans_val eq "power ratio to dB") {
  $pr = $ans;
  $dbm = 10 * (log10 $pr);
  $mw = 0;
  $v = 0;
  $vr = 10 ** ($dbm / 20);
  $m = " ";
}
elsif ($ans_val eq "dBm to volts across Z") {
  $dbm = $ans;
  $mw = 10 ** ($dbm / 10);
  $v = sqrt (( 10 ** ($dbm / 10) / 1000) * $imp);
  $vr = 10 ** ($dbm / 20);
  $pr = 10 ** ($dbm / 10);
  $m = "m";
}
elsif ($ans_val eq "volts across Z to dBm") {
  $v = $ans;
  $dbm = 10 * (log10 (($v ** 2 / $imp) * 1000));
  $mw = 10 ** ($dbm / 10);
  $vr = 10 ** ($dbm / 20);
  $pr = 10 ** ($dbm / 10);
  $m = "m";
}
elsif ($ans_val eq "dBi to dBd") {
 $dbi = $ans;
 $dbd = $dbi - 2.14;
 $pr = 10 ** ($dbd / 10);
 $vr = 0;
 $v = 0;
 $dbm = 0;
 $mw = 0;
 $m = " ";
}

# Make all pretty
#
$imp = sprintf "%.3f", $imp;

$dbm = sprintf "%.6f", $dbm;
$mw = sprintf "%.6f", $mw;

$v_u = sprintf "%.3f", $v * 1000000;
$v = sprintf "%.6f", $v;

$vr = sprintf "%.6f", $vr;
$pr = sprintf "%.6f", $pr;

$dbi = sprintf "%.3f", $dbi;
$dbd = sprintf "%.3f", $dbd;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Decibel Conversion Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Decibel Conversion Calculator Results</h2>
</center>

<hr noshade>
<pre>
$b Circuit impedance (Z) : $e$imp
<br>
                  $p dB$m : $e$dbm$p dB$m $e
           $p Milliwatts : $e$mw$p mW $e
        $p Voltage ratio : $e$vr$p to$e 1
          $p Power ratio : $e$pr$p to$e 1 
       $p Volts across Z : $e$v$p Volts ($e$v_u$p &micro;V) $e
<br>
  $p Antenna gain in dBi : $e$dbi$p dBi $e
  $p Antenna gain in dBd : $e$dbd$p dBd $e
</pre>

<hr noshade size="5">

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
