//
//Terminal window with scrollback buffer
// @ SV2AGW 2000
//
#include <winsock2.h>
#include "AGWTERMINALWIN.h"
#define min(a, b)  (((a) < (b)) ? (a) : (b))
#define max(a, b)  (((a) > (b)) ? (a) : (b))


AGWTERMINALWIN::AGWTERMINALWIN(HWND AParentWindow,int Rows,int Cols,LPSTR Atitle)
{
MAXROWS=Rows;
MAXCOLS=Cols;
lstrcpy(Title,Atitle);
ParentWindow=AParentWindow;
char test[100];wsprintf(test,"%d=%d",MAXROWS,MAXCOLS);OutputDebugString(test);
Screen=new char[MAXROWS*MAXCOLS+10];
if (!Screen) OutputDebugString("No SCREEN");
FillMemory(Screen,MAXROWS*MAXCOLS,' ');
//if (!Screen) MessageBox(NULL,"ERROR SCREEN","ERROR",MB_OK);
hTTYFont=0;
    //
    // initialize generial TTY info
    //
wCursorState= CS_HIDE ;
fAutowrap   = TRUE;
fNewLine    = FALSE;
xSize       = 0 ;
ySize       = 0 ;
xScroll     = 0 ;
yScroll     = 0 ;
nColumn     = 0 ;
nRow       = MAXROWS - 1 ;

//
// setup default font information
//
lfTTYFont.lfHeight =         12 ;
lfTTYFont.lfWidth =          0 ;
lfTTYFont.lfEscapement =     0 ;
lfTTYFont.lfOrientation =    0 ;
lfTTYFont.lfWeight =         0 ;
lfTTYFont.lfItalic =         0 ;
lfTTYFont.lfUnderline =      0 ;
lfTTYFont.lfStrikeOut =      0 ;
lfTTYFont.lfCharSet =        OEM_CHARSET ;
lfTTYFont.lfOutPrecision =   OUT_DEFAULT_PRECIS ;
lfTTYFont.lfClipPrecision =  CLIP_DEFAULT_PRECIS ;
lfTTYFont.lfQuality =        DEFAULT_QUALITY ;
lfTTYFont.lfPitchAndFamily = FIXED_PITCH | FF_MODERN ;
lstrcpy( lfTTYFont.lfFaceName, "FixedSys" ) ;
}

//-----------------------------------------------------------------------------
void AGWTERMINALWIN::InitNewFont(LOGFONT LogFont, COLORREF rgbColor)
{
    TEXTMETRIC tm;
    HDC        hDC;

    //
    // if old one exists, then I should delete it
    //
    if (hTTYFont)     DeleteObject(hTTYFont);

    lfTTYFont = LogFont;
    hTTYFont= CreateFontIndirect(&lfTTYFont);
    rgbFGColor = rgbColor;

    hDC = GetDC( HWND() ) ;
    SelectObject( hDC, hTTYFont ) ;
    GetTextMetrics( hDC, &tm ) ;
    ReleaseDC( HWND(), hDC ) ;

    //
    // character width and height
    //
    xChar = tm.tmAveCharWidth  ;
    yChar = tm.tmHeight + tm.tmExternalLeading ;

    xOffset = 0 ;
    yOffset = yChar * nRow;
}

//****************************************************

BOOL AGWTERMINALWIN::ScrollTTYVert(HWND hWnd,WORD wScrollCmd, WORD wScrollPos )
{
   int  nScrollAmt ;

   switch (wScrollCmd)
   {
      case SB_TOP:
         				nScrollAmt = -yOffset;
         				break ;
      case SB_BOTTOM:
         				nScrollAmt = yScroll - yOffset ;
         				break ;
      case SB_PAGEUP:
         				nScrollAmt = -ySize ;
         				break ;
      case SB_PAGEDOWN:
       					nScrollAmt = ySize;
                     break ;
      case SB_LINEUP:
         				nScrollAmt = -yChar ;
         				break ;
      case SB_LINEDOWN:
         				nScrollAmt = yChar ;
         				break ;
      case SB_THUMBPOSITION:
         						nScrollAmt = wScrollPos - yOffset ;
         						break ;
      default:
         			return ( FALSE ) ;
   }

   if ((yOffset + nScrollAmt) > yScroll)  nScrollAmt =yScroll - yOffset;

   if ((yOffset + nScrollAmt) < 0)  nScrollAmt = -yOffset ;
   ScrollWindowEx( hWnd, 0, -nScrollAmt, NULL, NULL, NULL, NULL, SW_INVALIDATE | SW_ERASE) ;
   yOffset = yOffset + nScrollAmt ;
   SetScrollPos( hWnd, SB_VERT, yOffset, TRUE ) ;
   return ( TRUE ) ;

} // end of ScrollTTYVert()

//---------------------------------------------------------------------------
BOOL AGWTERMINALWIN::ScrollTTYHorz(HWND hWnd, WORD wScrollCmd, WORD wScrollPos )
{
   int  nScrollAmt ;

   switch (wScrollCmd)
   {
      case SB_TOP:
         nScrollAmt = -xOffset ;
         break ;

      case SB_BOTTOM:
         nScrollAmt = xScroll- xOffset ;
         break ;

      case SB_PAGEUP:
         nScrollAmt = -xSize ;
         break ;

      case SB_PAGEDOWN:
         nScrollAmt = xSize ;
         break ;

      case SB_LINEUP:
         nScrollAmt = -xChar ;
         break ;

      case SB_LINEDOWN:
         nScrollAmt = xChar ;
         break ;

      case SB_THUMBPOSITION:
         nScrollAmt = wScrollPos - xOffset ;
         break ;

      default:
         return ( FALSE ) ;
   }
   if ((xOffset + nScrollAmt) > xScroll)  nScrollAmt = xScroll - xOffset ;
   if ((xOffset + nScrollAmt) < 0)     nScrollAmt = -xOffset ;
   ScrollWindowEx( hWnd, -nScrollAmt, 0, NULL, NULL, NULL, NULL, SW_INVALIDATE | SW_ERASE) ;
   xOffset  += nScrollAmt ;
   SetScrollPos( hWnd, SB_HORZ, xOffset, TRUE ) ;

   return ( TRUE ) ;

} // end of ScrollTTYHorz()

BOOL AGWTERMINALWIN::PaintTTY( HWND hWnd )
{
   PAINTSTRUCT  ps ;
   HFONT        hOldFont ;
   RECT         rect ;
   HDC          hDC ;
   int          nRow, nCol, nEndRow, nEndCol;
   int          nCount, nHorzPos, nVertPos ;

   hDC = BeginPaint( hWnd, &ps ) ;
   hOldFont = SelectObject( hDC, hTTYFont ) ;
   SetTextColor( hDC, rgbFGColor ) ;
   SetBkColor( hDC, GetSysColor( COLOR_WINDOW ) ) ;
   rect = ps.rcPaint ;
   nRow =   min( MAXROWS - 1, max( 0, (rect.top +yOffset) / yChar ) ) ;
   nEndRow =min( MAXROWS - 1, ((rect.bottom + yOffset - 1) / yChar ) ) ;
   nCol =   min( MAXCOLS - 1, max( 0, (rect.left + xOffset) / xChar ) ) ;
   nEndCol =min( MAXCOLS - 1,((rect.right + xOffset - 1) / xChar ) ) ;
   nCount = nEndCol - nCol + 1 ;
   for (; nRow <= nEndRow; nRow++)
   {
      nVertPos = (nRow * yChar) - yOffset ;
      nHorzPos = (nCol * xChar) - xOffset ;
      rect.top = nVertPos ;
      rect.bottom = nVertPos + yChar ;
      rect.left = nHorzPos ;
      rect.right = nHorzPos + xChar* nCount ;
      SetBkMode( hDC, OPAQUE ) ;
      ExtTextOut( hDC, nHorzPos, nVertPos, ETO_OPAQUE | ETO_CLIPPED, &rect,
                  (LPSTR)( Screen+ nRow * MAXCOLS + nCol ),
                  nCount, NULL ) ;
   }
   SelectObject( hDC, hOldFont ) ;
   EndPaint( hWnd, &ps ) ;
   MoveTTYCursor( hWnd ) ;
   return ( TRUE ) ;

} // end of PaintTTY()

//---------------------------------------------------------------------------
BOOL AGWTERMINALWIN::MoveTTYCursor( HWND hWnd )
{
   if (wCursorState & CS_SHOW)
      SetCaretPos((nColumn * xChar)-xOffset,(nRow * yChar) -yOffset) ;
   return ( TRUE ) ;

} // end of MoveTTYCursor()

//---------------------------------------------------------------------------
BOOL AGWTERMINALWIN::SetTTYFocus( HWND hWnd )
{
   if (wCursorState != CS_SHOW) 
   {
      CreateCaret( hWnd, NULL, xChar, yChar ) ;
      ShowCaret( hWnd ) ;
      wCursorState = CS_SHOW ;
   }
   MoveTTYCursor( hWnd ) ;
   return ( TRUE ) ;

} // end of SetTTYFocus()
//---------------------------------------------------------------------------
BOOL AGWTERMINALWIN::KillTTYFocus( HWND hWnd )
{
   if (wCursorState != CS_HIDE)
   {
      HideCaret( hWnd ) ;
      DestroyCaret() ;
      wCursorState = CS_HIDE ;
   }
   return ( TRUE ) ;

} // end of KillTTYFocus()
//---------------------------------------------------------------------------
BOOL AGWTERMINALWIN::SizeTTY( HWND hWnd, WORD wWidth, WORD wHeight )
{
   int nScrollAmt ;
   //
   // adjust vert settings
   //
   ySize = (int) wHeight ;
   yScroll = max( 0, (MAXROWS * yChar) -ySize ) ;
   nScrollAmt = min( yScroll, yOffset ) -yOffset ;
   ScrollWindow( HWND(), 0, -nScrollAmt, NULL, NULL ) ;

   yOffset = yOffset + nScrollAmt ;
   SetScrollPos( hWnd, SB_VERT, yOffset, FALSE ) ;
   SetScrollRange( hWnd, SB_VERT, 0, yScroll, TRUE ) ;

   //
   // adjust horz settings
   //
//   xSize = (int) wHeight ;
   xSize = (int) wWidth ;
   xScroll = max( 0, (MAXCOLS * xChar) -xSize ) ;
   nScrollAmt = min( xScroll, xOffset) -xOffset ;
   ScrollWindow( hWnd, nScrollAmt, 0, NULL, NULL );
   xOffset = xOffset + nScrollAmt ;
   SetScrollRange( hWnd, SB_HORZ, 0,xScroll, FALSE ) ;
   SetScrollPos( hWnd, SB_HORZ, xOffset, TRUE ) ;

   InvalidateRect( hWnd, NULL, FALSE ) ;   // redraw entire window

   return ( TRUE ) ;

} // end of SizeTTY()

//***********************************************************
//***********************************************************

LRESULT CALLBACK AGWTerminalWinProc(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam)
{
    AGWTERMINALWIN  * pCtrl = (AGWTERMINALWIN *)( GetWindowLong(hWnd,GWL_USERDATA));
      
    switch(uMessage)
    {
        case WM_CREATE:
                       OutputDebugString("WMCREATE CHILD");

            				SetWindowLong(hWnd,GWL_USERDATA, lParam);
                        return 0;
        case WM_VSCROLL:
                       OutputDebugString("WMVSCROLL");

            				pCtrl->ScrollTTYVert( hWnd, LOWORD( wParam ), HIWORD( wParam ) ) ;
    							return 0L;
        case WM_HSCROLL:
                       OutputDebugString("WMHSCROLL");
            				pCtrl->ScrollTTYHorz( hWnd, LOWORD( wParam ), HIWORD( wParam ) ) ;
    							return 0L;
        case WM_SIZE:
                       OutputDebugString("WMSIZE");
            				pCtrl->SizeTTY(hWnd, LOWORD(lParam), HIWORD(lParam));
    							break;;
        case WM_PAINT:
                       OutputDebugString("WMPAINT");
            				pCtrl->PaintTTY(hWnd);
    							return 0L;
        case WM_SETFOCUS:
                       OutputDebugString("WMSETFOCUS");
             				pCtrl->SetTTYFocus( hWnd ) ;
    							return 0L;
        case WM_KILLFOCUS:
                       OutputDebugString("WMKILLFOCUS");
            				pCtrl->KillTTYFocus( hWnd ) ;
             				return 0L;
        case WM_MOUSEACTIVATE:
                       OutputDebugString("WMMOUSE");
            				SetFocus(hWnd);
            				return MA_ACTIVATE;

        default:
					return  DefMDIChildProc(hWnd, uMessage, wParam, lParam);

    }//end switch
					return  DefMDIChildProc(hWnd, uMessage, wParam, lParam);

}

////////////////////////////////////
/*void AGWTERMINALWIN::InsertData(LPSTR Data,int DataLen)
{

} */
//****************************
