//----------------------------------------------------------------------------
//	                    Definitions for PSA cards
//      Demo software accompanying the  QEX  August  1994 article:	       
//      "Using a Programmable PC Sound Card for Amateur Radio"         
//                  (c) Johan Forrer, KC7WW			       
//		                26553 Priceview Drive                             
//                     Monroe, OR 97456				       
//----------------------------------------------------------------------------
//
// PSA-defined interrupt codes
#define NOIRQ		0x0000
#define IRQ3		0x0008
#define IRQ5		0x0010
#define IRQ7		0x0018
#define IRQ9		0x0020
#define IRQ10		0x0028
#define IRQ11     0x0030
#define IRQ12		0x0038

// PC interrupt vector numbers
#define INT_3     0x0B		// INT 3
#define INT_5     0x0D		// INT 5
#define INT_7     0x0F		// INT 7

// WSS register address offsets from WSS base address.
#define WSS_STATUS			   0x0003
#define WSS_CODECINDEXADDR		0x0004
#define WSS_CODECINDEXDATA		0x0005
#define WSS_CODECSTATUS			0x0006
#define WSS_CODECDATA			0x0007

// ASIC Types
#define ESC614 0
#define ESC615 1

// PSS port addresses
#define PSS_DATA_614     0x220
#define PSS_STATUS_614   0x222
#define PSS_CONTROL_614  0x222
#define PSS_ID_VERS_614  0x224

#define PSS_DATA_615     0x230
#define PSS_CONTROL_615  0x232
#define PSS_STATUS_615   0x234
#define PSS_INDEXED_615  0x236

// configuration addresses
#define PSS_CONFIG_614   0x10
#define WSS_CONFIG_614   0x12

#define ID_VERSION_615   0
#define PSS_CONFIG_615   1
#define WSS_CONFIG_615   7

#define PSS_STAT_WE	   0x8000 	//Write empty. The DSP has read the previous
											//contents of the PC data register and the PC
											//may write new data
#define PSS_STAT_RF	   0x4000	//Read full. The DSP has written new data to
											//The DSP data register since it was last read
#define PSS_CNTRL_RESET 0x2000	// To pull on the hardware reset line 

#define PSS_STAT_FLAG3  0x0800 	//Flag settable by DSP or'd with inverted BG
											//for testing during boot sequence
#define PSS_STAT_RF	   0x4000	//Read full. The DSP has written new data to
											//The DSP data register since it was last read


/* PSS DSP Debug code equates */
#define READ_DATA_CMD   0xd0
#define WRITE_DATA_CMD  0xd1
#define READ_PROG_CMD   0xd2
#define WRITE_PROG_CMD  0xd3
#define PROG_ID_CMD     0xd4  

#define DELAY 100					// 100 ms delay
